/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.OwlEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class OwlModel<T extends OwlEntity>
extends AdvancedEntityModel<T> {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart Tail;
    private final ModelPart LeftWing;
    private final ModelPart RightWing;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;

    public OwlModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Head = this.Body.m_171324_("Head");
        this.Tail = this.Body.m_171324_("Tail");
        this.LeftWing = this.Body.m_171324_("LeftWing");
        this.RightWing = this.Body.m_171324_("RightWing");
        this.LeftLeg = this.Body.m_171324_("LeftLeg");
        this.RightLeg = this.Body.m_171324_("RightLeg");
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStack.m_85837_(0.0, 1.5, 0.0);
        }
        this.Body.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setRotationAngles(OwlModel.getOwlState(entity), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.setLivingAnimations(OwlModel.getOwlState(entity), (OwlEntity)entity);
    }

    public void setRotationAngles(OwlState state, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104203_ = -0.174532f + headPitch * ((float)Math.PI / 180);
        this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.Head.f_104205_ = 0.0f;
        this.Head.f_104200_ = 0.0f;
        this.Body.f_104200_ = 0.0f;
        this.Tail.f_104200_ = 0.0f;
        this.RightWing.f_104200_ = -3.5f;
        this.LeftWing.f_104200_ = 3.5f;
        switch (state) {
            case SITTING: {
                break;
            }
            case STANDING: {
                this.LeftLeg.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
                this.RightLeg.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
                break;
            }
            default: {
                this.Tail.f_104203_ = -0.959931f + Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.3f * limbSwingAmount;
                this.LeftWing.f_104205_ = -0.0873f - ageInTicks;
                this.RightWing.f_104205_ = 0.0873f + ageInTicks;
            }
        }
    }

    public void setLivingAnimations(OwlState state, OwlEntity owl) {
        this.Body.f_104203_ = 0.174532f;
        this.LeftWing.f_104203_ = 0.0f;
        this.LeftWing.f_104204_ = 0.0f;
        this.LeftWing.f_104205_ = -0.130899f;
        this.RightWing.f_104203_ = 0.0f;
        this.RightWing.f_104204_ = 0.0f;
        this.RightWing.f_104205_ = 0.130899f;
        this.LeftLeg.f_104203_ = -0.261799f;
        this.LeftLeg.f_104201_ = -1.9107f;
        this.LeftLeg.f_104205_ = 0.0f;
        this.RightLeg.f_104203_ = -0.261799f;
        this.RightLeg.f_104201_ = -1.9107f;
        this.RightLeg.f_104205_ = 0.0f;
        switch (state) {
            case SITTING: {
                this.Body.f_104203_ = 0.0f;
                this.LeftLeg.f_104203_ = 0.0f;
                this.RightLeg.f_104203_ = 0.0f;
                break;
            }
            case FLYING: {
                if (!(owl.m_20184_().m_165925_() > 1.0E-7)) break;
                this.LeftLeg.f_104203_ += 0.6981317f;
                this.RightLeg.f_104203_ += 0.6981317f;
                break;
            }
        }
    }

    private static OwlState getOwlState(OwlEntity owl) {
        if (owl.m_21825_() || owl.m_5803_()) {
            return OwlState.SITTING;
        }
        return owl.m_29443_() ? OwlState.FLYING : OwlState.STANDING;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-3.5f, -9.025f, -3.5f, 7.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition LeftWing = Body.m_171599_("LeftWing", CubeListBuilder.m_171558_().m_171514_(0, 1).m_171488_(0.0f, 0.0f, -3.0f, 1.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.5f, (float)-8.5792f, (float)-0.4056f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition RightWing = Body.m_171599_("RightWing", CubeListBuilder.m_171558_().m_171514_(15, 1).m_171488_(-1.0f, 0.0f, -3.0f, 1.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5f, (float)-8.5792f, (float)-0.4056f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition LeftLeg = Body.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(31, 1).m_171488_(-1.0f, 0.1224f, -0.5671f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-1.9107f, (float)-1.5699f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFoot = LeftLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(40, 3).m_171488_(-1.0667f, -0.0681f, -1.058f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0667f, (float)3.0978f, (float)0.5107f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightToeLeftFoot = LeftFoot.m_171599_("RightToeLeftFoot", CubeListBuilder.m_171558_().m_171514_(49, 4).m_171488_(-0.5f, -0.475f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5667f, (float)0.4082f, (float)-1.0494f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition LeftToeLeftFoot = LeftFoot.m_171599_("LeftToeLeftFoot", CubeListBuilder.m_171558_().m_171514_(54, 4).m_171488_(-0.5f, -0.5f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.4333f, (float)0.4332f, (float)-1.0494f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition RightLeg = Body.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(31, 7).m_171488_(-1.0f, 0.1224f, -0.5671f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-1.9107f, (float)-1.5699f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition RightFoot = RightLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(40, 9).m_171488_(-1.0667f, -0.0681f, -1.058f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0667f, (float)3.0978f, (float)0.5107f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightToeRightFoot = RightFoot.m_171599_("RightToeRightFoot", CubeListBuilder.m_171558_().m_171514_(49, 10).m_171488_(-0.5f, -0.475f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5667f, (float)0.4082f, (float)-1.0494f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition LeftToeRightFoot = RightFoot.m_171599_("LeftToeRightFoot", CubeListBuilder.m_171558_().m_171514_(54, 10).m_171488_(-0.5f, -0.5f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.4333f, (float)0.4332f, (float)-1.0494f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(31, 13).m_171488_(-1.0f, -0.5186f, -0.2595f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.7652f, (float)1.3264f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(27, 20).m_171488_(-3.5f, -6.0f, -3.25f, 7.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.5045f, (float)-0.1394f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition Beak = Head.m_171599_("Beak", CubeListBuilder.m_171558_().m_171514_(42, 14).m_171488_(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.25f, (float)-2.7f, (float)0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public static enum OwlState {
        FLYING,
        STANDING,
        SITTING;

    }
}

